package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AutoMLSortBy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy
}
object AutoMLSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy
  ): zio.aws.sagemaker.model.AutoMLSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy.STATUS =>
      val r = Status
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.AutoMLSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy =
      software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.sagemaker.model.AutoMLSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy =
      software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy.NAME
  }
  case object CreationTime extends zio.aws.sagemaker.model.AutoMLSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy =
      software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy.CREATION_TIME
  }
  case object Status extends zio.aws.sagemaker.model.AutoMLSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy =
      software.amazon.awssdk.services.sagemaker.model.AutoMLSortBy.STATUS
  }
}
