package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters.*
final case class AdditionalS3DataSource(
    s3DataType: zio.aws.sagemaker.model.AdditionalS3DataSourceDataType,
    s3Uri: S3Uri,
    compressionType: Optional[zio.aws.sagemaker.model.CompressionType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSource = {
    import AdditionalS3DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSource
      .builder()
      .s3DataType(s3DataType.unwrap)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AdditionalS3DataSource.ReadOnly =
    zio.aws.sagemaker.model.AdditionalS3DataSource.wrap(buildAwsValue())
}
object AdditionalS3DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AdditionalS3DataSource =
      zio.aws.sagemaker.model.AdditionalS3DataSource(
        s3DataType,
        s3Uri,
        compressionType.map(value => value)
      )
    def s3DataType: zio.aws.sagemaker.model.AdditionalS3DataSourceDataType
    def s3Uri: S3Uri
    def compressionType: Optional[zio.aws.sagemaker.model.CompressionType]
    def getS3DataType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AdditionalS3DataSourceDataType
    ] = ZIO.succeed(s3DataType)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getCompressionType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSource
  ) extends zio.aws.sagemaker.model.AdditionalS3DataSource.ReadOnly {
    override val s3DataType
        : zio.aws.sagemaker.model.AdditionalS3DataSourceDataType =
      zio.aws.sagemaker.model.AdditionalS3DataSourceDataType
        .wrap(impl.s3DataType())
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
    override val compressionType
        : Optional[zio.aws.sagemaker.model.CompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compressionType())
        .map(value => zio.aws.sagemaker.model.CompressionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AdditionalS3DataSource
  ): zio.aws.sagemaker.model.AdditionalS3DataSource.ReadOnly = new Wrapper(impl)
}
