package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  FeatureParameterKey,
  FeatureDescription,
  FeatureName,
  FeatureGroupNameOrArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateFeatureMetadataRequest(
    featureGroupName: FeatureGroupNameOrArn,
    featureName: FeatureName,
    description: Optional[FeatureDescription] = Optional.Absent,
    parameterAdditions: Optional[
      Iterable[zio.aws.sagemaker.model.FeatureParameter]
    ] = Optional.Absent,
    parameterRemovals: Optional[Iterable[FeatureParameterKey]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest = {
    import UpdateFeatureMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest
      .builder()
      .featureGroupName(
        FeatureGroupNameOrArn.unwrap(featureGroupName): java.lang.String
      )
      .featureName(FeatureName.unwrap(featureName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          FeatureDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        parameterAdditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterAdditions)
      .optionallyWith(
        parameterRemovals.map(value =>
          value.map { item =>
            FeatureParameterKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parameterRemovals)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateFeatureMetadataRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateFeatureMetadataRequest.wrap(buildAwsValue())
}
object UpdateFeatureMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateFeatureMetadataRequest =
      zio.aws.sagemaker.model.UpdateFeatureMetadataRequest(
        featureGroupName,
        featureName,
        description.map(value => value),
        parameterAdditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameterRemovals.map(value => value)
      )
    def featureGroupName: FeatureGroupNameOrArn
    def featureName: FeatureName
    def description: Optional[FeatureDescription]
    def parameterAdditions
        : Optional[List[zio.aws.sagemaker.model.FeatureParameter.ReadOnly]]
    def parameterRemovals: Optional[List[FeatureParameterKey]]
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupNameOrArn] =
      ZIO.succeed(featureGroupName)
    def getFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(featureName)
    def getDescription: ZIO[Any, AwsError, FeatureDescription] =
      AwsError.unwrapOptionField("description", description)
    def getParameterAdditions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.FeatureParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterAdditions", parameterAdditions)
    def getParameterRemovals: ZIO[Any, AwsError, List[FeatureParameterKey]] =
      AwsError.unwrapOptionField("parameterRemovals", parameterRemovals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest
  ) extends zio.aws.sagemaker.model.UpdateFeatureMetadataRequest.ReadOnly {
    override val featureGroupName: FeatureGroupNameOrArn =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupNameOrArn(impl.featureGroupName())
    override val featureName: FeatureName =
      zio.aws.sagemaker.model.primitives.FeatureName(impl.featureName())
    override val description: Optional[FeatureDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FeatureDescription(value)
        )
    override val parameterAdditions
        : Optional[List[zio.aws.sagemaker.model.FeatureParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterAdditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.FeatureParameter.wrap(item)
          }.toList
        )
    override val parameterRemovals: Optional[List[FeatureParameterKey]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterRemovals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.FeatureParameterKey(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest
  ): zio.aws.sagemaker.model.UpdateFeatureMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
