package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TrafficType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TrafficType
}
object TrafficType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TrafficType
  ): zio.aws.sagemaker.model.TrafficType = value match {
    case software.amazon.awssdk.services.sagemaker.model.TrafficType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TrafficType.PHASES =>
      val r = PHASES
      r
    case software.amazon.awssdk.services.sagemaker.model.TrafficType.STAIRS =>
      val r = STAIRS
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.TrafficType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrafficType =
      software.amazon.awssdk.services.sagemaker.model.TrafficType.UNKNOWN_TO_SDK_VERSION
  }
  case object PHASES extends zio.aws.sagemaker.model.TrafficType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrafficType =
      software.amazon.awssdk.services.sagemaker.model.TrafficType.PHASES
  }
  case object STAIRS extends zio.aws.sagemaker.model.TrafficType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrafficType =
      software.amazon.awssdk.services.sagemaker.model.TrafficType.STAIRS
  }
}
