package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  FillingTransformationValue,
  TransformationAttributeName
}
import scala.jdk.CollectionConverters.*
final case class TimeSeriesTransformations(
    filling: Optional[Map[
      TransformationAttributeName,
      Map[zio.aws.sagemaker.model.FillingType, FillingTransformationValue]
    ]] = Optional.Absent,
    aggregation: Optional[Map[
      TransformationAttributeName,
      zio.aws.sagemaker.model.AggregationTransformationValue
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TimeSeriesTransformations = {
    import TimeSeriesTransformations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TimeSeriesTransformations
      .builder()
      .optionallyWith(
        filling.map(value =>
          value
            .map({ case (key, value) =>
              (TransformationAttributeName
                .unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  key.unwrap.toString -> (FillingTransformationValue
                    .unwrap(value): java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.fillingWithStrings)
      .optionallyWith(
        aggregation.map(value =>
          value
            .map({ case (key, value) =>
              (TransformationAttributeName
                .unwrap(key): java.lang.String) -> value.unwrap.toString
            })
            .asJava
        )
      )(_.aggregationWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TimeSeriesTransformations.ReadOnly =
    zio.aws.sagemaker.model.TimeSeriesTransformations.wrap(buildAwsValue())
}
object TimeSeriesTransformations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TimeSeriesTransformations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TimeSeriesTransformations =
      zio.aws.sagemaker.model.TimeSeriesTransformations(
        filling.map(value => value),
        aggregation.map(value => value)
      )
    def filling: Optional[Map[
      TransformationAttributeName,
      Map[zio.aws.sagemaker.model.FillingType, FillingTransformationValue]
    ]]
    def aggregation: Optional[Map[
      TransformationAttributeName,
      zio.aws.sagemaker.model.AggregationTransformationValue
    ]]
    def getFilling: ZIO[Any, AwsError, Map[
      TransformationAttributeName,
      Map[zio.aws.sagemaker.model.FillingType, FillingTransformationValue]
    ]] = AwsError.unwrapOptionField("filling", filling)
    def getAggregation: ZIO[Any, AwsError, Map[
      TransformationAttributeName,
      zio.aws.sagemaker.model.AggregationTransformationValue
    ]] = AwsError.unwrapOptionField("aggregation", aggregation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TimeSeriesTransformations
  ) extends zio.aws.sagemaker.model.TimeSeriesTransformations.ReadOnly {
    override val filling: Optional[Map[
      TransformationAttributeName,
      Map[zio.aws.sagemaker.model.FillingType, FillingTransformationValue]
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.filling())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives
              .TransformationAttributeName(key) -> value.asScala
              .map({ case (key, value) =>
                zio.aws.sagemaker.model.FillingType
                  .wrap(key) -> zio.aws.sagemaker.model.primitives
                  .FillingTransformationValue(value)
              })
              .toMap
          })
          .toMap
      )
    override val aggregation: Optional[Map[
      TransformationAttributeName,
      zio.aws.sagemaker.model.AggregationTransformationValue
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.aggregation())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TransformationAttributeName(
              key
            ) -> zio.aws.sagemaker.model.AggregationTransformationValue
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TimeSeriesTransformations
  ): zio.aws.sagemaker.model.TimeSeriesTransformations.ReadOnly = new Wrapper(
    impl
  )
}
