package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TabularResolvedAttributes(
    problemType: Optional[zio.aws.sagemaker.model.ProblemType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TabularResolvedAttributes = {
    import TabularResolvedAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TabularResolvedAttributes
      .builder()
      .optionallyWith(problemType.map(value => value.unwrap))(_.problemType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TabularResolvedAttributes.ReadOnly =
    zio.aws.sagemaker.model.TabularResolvedAttributes.wrap(buildAwsValue())
}
object TabularResolvedAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TabularResolvedAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TabularResolvedAttributes =
      zio.aws.sagemaker.model
        .TabularResolvedAttributes(problemType.map(value => value))
    def problemType: Optional[zio.aws.sagemaker.model.ProblemType]
    def getProblemType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProblemType] =
      AwsError.unwrapOptionField("problemType", problemType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TabularResolvedAttributes
  ) extends zio.aws.sagemaker.model.TabularResolvedAttributes.ReadOnly {
    override val problemType: Optional[zio.aws.sagemaker.model.ProblemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.problemType())
        .map(value => zio.aws.sagemaker.model.ProblemType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TabularResolvedAttributes
  ): zio.aws.sagemaker.model.TabularResolvedAttributes.ReadOnly = new Wrapper(
    impl
  )
}
