package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  SampleWeightAttributeName,
  TargetAttributeName,
  GenerateCandidateDefinitionsOnly,
  S3Uri
}
import scala.jdk.CollectionConverters.*
final case class TabularJobConfig(
    candidateGenerationConfig: Optional[
      zio.aws.sagemaker.model.CandidateGenerationConfig
    ] = Optional.Absent,
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent,
    featureSpecificationS3Uri: Optional[S3Uri] = Optional.Absent,
    mode: Optional[zio.aws.sagemaker.model.AutoMLMode] = Optional.Absent,
    generateCandidateDefinitionsOnly: Optional[
      GenerateCandidateDefinitionsOnly
    ] = Optional.Absent,
    problemType: Optional[zio.aws.sagemaker.model.ProblemType] =
      Optional.Absent,
    targetAttributeName: TargetAttributeName,
    sampleWeightAttributeName: Optional[SampleWeightAttributeName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TabularJobConfig = {
    import TabularJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TabularJobConfig
      .builder()
      .optionallyWith(
        candidateGenerationConfig.map(value => value.buildAwsValue())
      )(_.candidateGenerationConfig)
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .optionallyWith(
        featureSpecificationS3Uri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.featureSpecificationS3Uri)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        generateCandidateDefinitionsOnly.map(value =>
          GenerateCandidateDefinitionsOnly.unwrap(value): java.lang.Boolean
        )
      )(_.generateCandidateDefinitionsOnly)
      .optionallyWith(problemType.map(value => value.unwrap))(_.problemType)
      .targetAttributeName(
        TargetAttributeName.unwrap(targetAttributeName): java.lang.String
      )
      .optionallyWith(
        sampleWeightAttributeName.map(value =>
          SampleWeightAttributeName.unwrap(value): java.lang.String
        )
      )(_.sampleWeightAttributeName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TabularJobConfig.ReadOnly =
    zio.aws.sagemaker.model.TabularJobConfig.wrap(buildAwsValue())
}
object TabularJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TabularJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TabularJobConfig =
      zio.aws.sagemaker.model.TabularJobConfig(
        candidateGenerationConfig.map(value => value.asEditable),
        completionCriteria.map(value => value.asEditable),
        featureSpecificationS3Uri.map(value => value),
        mode.map(value => value),
        generateCandidateDefinitionsOnly.map(value => value),
        problemType.map(value => value),
        targetAttributeName,
        sampleWeightAttributeName.map(value => value)
      )
    def candidateGenerationConfig
        : Optional[zio.aws.sagemaker.model.CandidateGenerationConfig.ReadOnly]
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def featureSpecificationS3Uri: Optional[S3Uri]
    def mode: Optional[zio.aws.sagemaker.model.AutoMLMode]
    def generateCandidateDefinitionsOnly
        : Optional[GenerateCandidateDefinitionsOnly]
    def problemType: Optional[zio.aws.sagemaker.model.ProblemType]
    def targetAttributeName: TargetAttributeName
    def sampleWeightAttributeName: Optional[SampleWeightAttributeName]
    def getCandidateGenerationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CandidateGenerationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "candidateGenerationConfig",
      candidateGenerationConfig
    )
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
    def getFeatureSpecificationS3Uri: ZIO[Any, AwsError, S3Uri] = AwsError
      .unwrapOptionField("featureSpecificationS3Uri", featureSpecificationS3Uri)
    def getMode: ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getGenerateCandidateDefinitionsOnly
        : ZIO[Any, AwsError, GenerateCandidateDefinitionsOnly] =
      AwsError.unwrapOptionField(
        "generateCandidateDefinitionsOnly",
        generateCandidateDefinitionsOnly
      )
    def getProblemType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProblemType] =
      AwsError.unwrapOptionField("problemType", problemType)
    def getTargetAttributeName: ZIO[Any, Nothing, TargetAttributeName] =
      ZIO.succeed(targetAttributeName)
    def getSampleWeightAttributeName
        : ZIO[Any, AwsError, SampleWeightAttributeName] = AwsError
      .unwrapOptionField("sampleWeightAttributeName", sampleWeightAttributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TabularJobConfig
  ) extends zio.aws.sagemaker.model.TabularJobConfig.ReadOnly {
    override val candidateGenerationConfig
        : Optional[zio.aws.sagemaker.model.CandidateGenerationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.candidateGenerationConfig())
        .map(value =>
          zio.aws.sagemaker.model.CandidateGenerationConfig.wrap(value)
        )
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
    override val featureSpecificationS3Uri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureSpecificationS3Uri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val mode: Optional[zio.aws.sagemaker.model.AutoMLMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.sagemaker.model.AutoMLMode.wrap(value))
    override val generateCandidateDefinitionsOnly
        : Optional[GenerateCandidateDefinitionsOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.generateCandidateDefinitionsOnly())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .GenerateCandidateDefinitionsOnly(value)
      )
    override val problemType: Optional[zio.aws.sagemaker.model.ProblemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.problemType())
        .map(value => zio.aws.sagemaker.model.ProblemType.wrap(value))
    override val targetAttributeName: TargetAttributeName =
      zio.aws.sagemaker.model.primitives
        .TargetAttributeName(impl.targetAttributeName())
    override val sampleWeightAttributeName
        : Optional[SampleWeightAttributeName] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleWeightAttributeName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.SampleWeightAttributeName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TabularJobConfig
  ): zio.aws.sagemaker.model.TabularJobConfig.ReadOnly = new Wrapper(impl)
}
