package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait Statistic {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.Statistic
}
object Statistic {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.Statistic
  ): zio.aws.sagemaker.model.Statistic = value match {
    case software.amazon.awssdk.services.sagemaker.model.Statistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.Statistic.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.sagemaker.model.Statistic.MINIMUM =>
      val r = Minimum
      r
    case software.amazon.awssdk.services.sagemaker.model.Statistic.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.sagemaker.model.Statistic.SAMPLE_COUNT =>
      val r = SampleCount
      r
    case software.amazon.awssdk.services.sagemaker.model.Statistic.SUM =>
      val r = Sum
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Statistic =
      software.amazon.awssdk.services.sagemaker.model.Statistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Average extends zio.aws.sagemaker.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Statistic =
      software.amazon.awssdk.services.sagemaker.model.Statistic.AVERAGE
  }
  case object Minimum extends zio.aws.sagemaker.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Statistic =
      software.amazon.awssdk.services.sagemaker.model.Statistic.MINIMUM
  }
  case object Maximum extends zio.aws.sagemaker.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Statistic =
      software.amazon.awssdk.services.sagemaker.model.Statistic.MAXIMUM
  }
  case object SampleCount extends zio.aws.sagemaker.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Statistic =
      software.amazon.awssdk.services.sagemaker.model.Statistic.SAMPLE_COUNT
  }
  case object Sum extends zio.aws.sagemaker.model.Statistic {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Statistic =
      software.amazon.awssdk.services.sagemaker.model.Statistic.SUM
  }
}
