package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{KmsKeyId, S3Uri}
import scala.jdk.CollectionConverters.*
final case class S3StorageConfig(
    s3Uri: S3Uri,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    resolvedOutputS3Uri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.S3StorageConfig = {
    import S3StorageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.S3StorageConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        resolvedOutputS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.resolvedOutputS3Uri)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.S3StorageConfig.ReadOnly =
    zio.aws.sagemaker.model.S3StorageConfig.wrap(buildAwsValue())
}
object S3StorageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.S3StorageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.S3StorageConfig =
      zio.aws.sagemaker.model.S3StorageConfig(
        s3Uri,
        kmsKeyId.map(value => value),
        resolvedOutputS3Uri.map(value => value)
      )
    def s3Uri: S3Uri
    def kmsKeyId: Optional[KmsKeyId]
    def resolvedOutputS3Uri: Optional[S3Uri]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getResolvedOutputS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("resolvedOutputS3Uri", resolvedOutputS3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.S3StorageConfig
  ) extends zio.aws.sagemaker.model.S3StorageConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val resolvedOutputS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.resolvedOutputS3Uri())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.S3StorageConfig
  ): zio.aws.sagemaker.model.S3StorageConfig.ReadOnly = new Wrapper(impl)
}
