package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ServerlessProvisionedConcurrency,
  ServerlessMaxConcurrency,
  ServerlessMemorySizeInMB
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ProductionVariantServerlessConfig(
    memorySizeInMB: ServerlessMemorySizeInMB,
    maxConcurrency: ServerlessMaxConcurrency,
    provisionedConcurrency: Optional[ServerlessProvisionedConcurrency] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig = {
    import ProductionVariantServerlessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig
      .builder()
      .memorySizeInMB(ServerlessMemorySizeInMB.unwrap(memorySizeInMB): Integer)
      .maxConcurrency(ServerlessMaxConcurrency.unwrap(maxConcurrency): Integer)
      .optionallyWith(
        provisionedConcurrency.map(value =>
          ServerlessProvisionedConcurrency.unwrap(value): Integer
        )
      )(_.provisionedConcurrency)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly =
    zio.aws.sagemaker.model.ProductionVariantServerlessConfig
      .wrap(buildAwsValue())
}
object ProductionVariantServerlessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProductionVariantServerlessConfig =
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig(
        memorySizeInMB,
        maxConcurrency,
        provisionedConcurrency.map(value => value)
      )
    def memorySizeInMB: ServerlessMemorySizeInMB
    def maxConcurrency: ServerlessMaxConcurrency
    def provisionedConcurrency: Optional[ServerlessProvisionedConcurrency]
    def getMemorySizeInMB: ZIO[Any, Nothing, ServerlessMemorySizeInMB] =
      ZIO.succeed(memorySizeInMB)
    def getMaxConcurrency: ZIO[Any, Nothing, ServerlessMaxConcurrency] =
      ZIO.succeed(maxConcurrency)
    def getProvisionedConcurrency
        : ZIO[Any, AwsError, ServerlessProvisionedConcurrency] = AwsError
      .unwrapOptionField("provisionedConcurrency", provisionedConcurrency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig
  ) extends zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly {
    override val memorySizeInMB: ServerlessMemorySizeInMB =
      zio.aws.sagemaker.model.primitives
        .ServerlessMemorySizeInMB(impl.memorySizeInMB())
    override val maxConcurrency: ServerlessMaxConcurrency =
      zio.aws.sagemaker.model.primitives
        .ServerlessMaxConcurrency(impl.maxConcurrency())
    override val provisionedConcurrency
        : Optional[ServerlessProvisionedConcurrency] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedConcurrency())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .ServerlessProvisionedConcurrency(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig
  ): zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly =
    new Wrapper(impl)
}
