package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringMaxRuntimeInSeconds
import scala.jdk.CollectionConverters.*
final case class MonitoringStoppingCondition(
    maxRuntimeInSeconds: MonitoringMaxRuntimeInSeconds
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition = {
    import MonitoringStoppingCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition
      .builder()
      .maxRuntimeInSeconds(
        MonitoringMaxRuntimeInSeconds.unwrap(maxRuntimeInSeconds): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly =
    zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(buildAwsValue())
}
object MonitoringStoppingCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringStoppingCondition =
      zio.aws.sagemaker.model.MonitoringStoppingCondition(maxRuntimeInSeconds)
    def maxRuntimeInSeconds: MonitoringMaxRuntimeInSeconds
    def getMaxRuntimeInSeconds
        : ZIO[Any, Nothing, MonitoringMaxRuntimeInSeconds] =
      ZIO.succeed(maxRuntimeInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition
  ) extends zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly {
    override val maxRuntimeInSeconds: MonitoringMaxRuntimeInSeconds =
      zio.aws.sagemaker.model.primitives
        .MonitoringMaxRuntimeInSeconds(impl.maxRuntimeInSeconds())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringStoppingCondition
  ): zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly = new Wrapper(
    impl
  )
}
