package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MonitoringDatasetFormat(
    csv: Optional[zio.aws.sagemaker.model.MonitoringCsvDatasetFormat] =
      Optional.Absent,
    json: Optional[zio.aws.sagemaker.model.MonitoringJsonDatasetFormat] =
      Optional.Absent,
    parquet: Optional[zio.aws.sagemaker.model.MonitoringParquetDatasetFormat] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringDatasetFormat = {
    import MonitoringDatasetFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringDatasetFormat
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .optionallyWith(json.map(value => value.buildAwsValue()))(_.json)
      .optionallyWith(parquet.map(value => value.buildAwsValue()))(_.parquet)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringDatasetFormat.ReadOnly =
    zio.aws.sagemaker.model.MonitoringDatasetFormat.wrap(buildAwsValue())
}
object MonitoringDatasetFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringDatasetFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringDatasetFormat =
      zio.aws.sagemaker.model.MonitoringDatasetFormat(
        csv.map(value => value.asEditable),
        json.map(value => value.asEditable),
        parquet.map(value => value.asEditable)
      )
    def csv
        : Optional[zio.aws.sagemaker.model.MonitoringCsvDatasetFormat.ReadOnly]
    def json
        : Optional[zio.aws.sagemaker.model.MonitoringJsonDatasetFormat.ReadOnly]
    def parquet: Optional[
      zio.aws.sagemaker.model.MonitoringParquetDatasetFormat.ReadOnly
    ]
    def getCsv: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringCsvDatasetFormat.ReadOnly
    ] = AwsError.unwrapOptionField("csv", csv)
    def getJson: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringJsonDatasetFormat.ReadOnly
    ] = AwsError.unwrapOptionField("json", json)
    def getParquet: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringParquetDatasetFormat.ReadOnly
    ] = AwsError.unwrapOptionField("parquet", parquet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringDatasetFormat
  ) extends zio.aws.sagemaker.model.MonitoringDatasetFormat.ReadOnly {
    override val csv: Optional[
      zio.aws.sagemaker.model.MonitoringCsvDatasetFormat.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.csv())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringCsvDatasetFormat.wrap(value)
      )
    override val json: Optional[
      zio.aws.sagemaker.model.MonitoringJsonDatasetFormat.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.json())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringJsonDatasetFormat.wrap(value)
      )
    override val parquet: Optional[
      zio.aws.sagemaker.model.MonitoringParquetDatasetFormat.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parquet())
      .map(value =>
        zio.aws.sagemaker.model.MonitoringParquetDatasetFormat.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringDatasetFormat
  ): zio.aws.sagemaker.model.MonitoringDatasetFormat.ReadOnly = new Wrapper(
    impl
  )
}
