package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListMonitoringAlertHistoryResponse(
    monitoringAlertHistory: Optional[
      Iterable[zio.aws.sagemaker.model.MonitoringAlertHistorySummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse = {
    import ListMonitoringAlertHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse
      .builder()
      .optionallyWith(
        monitoringAlertHistory.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitoringAlertHistory)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListMonitoringAlertHistoryResponse.ReadOnly =
    zio.aws.sagemaker.model.ListMonitoringAlertHistoryResponse
      .wrap(buildAwsValue())
}
object ListMonitoringAlertHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListMonitoringAlertHistoryResponse =
      zio.aws.sagemaker.model.ListMonitoringAlertHistoryResponse(
        monitoringAlertHistory.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def monitoringAlertHistory: Optional[
      List[zio.aws.sagemaker.model.MonitoringAlertHistorySummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getMonitoringAlertHistory: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MonitoringAlertHistorySummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "monitoringAlertHistory",
      monitoringAlertHistory
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse
  ) extends zio.aws.sagemaker.model.ListMonitoringAlertHistoryResponse.ReadOnly {
    override val monitoringAlertHistory: Optional[
      List[zio.aws.sagemaker.model.MonitoringAlertHistorySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringAlertHistory())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.MonitoringAlertHistorySummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse
  ): zio.aws.sagemaker.model.ListMonitoringAlertHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
