package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.SecretArn
import scala.jdk.CollectionConverters.*
final case class IdentityProviderOAuthSetting(
    dataSourceName: Optional[zio.aws.sagemaker.model.DataSourceName] =
      Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.FeatureStatus] = Optional.Absent,
    secretArn: Optional[SecretArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting = {
    import IdentityProviderOAuthSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting
      .builder()
      .optionallyWith(dataSourceName.map(value => value.unwrap))(
        _.dataSourceName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.IdentityProviderOAuthSetting.ReadOnly =
    zio.aws.sagemaker.model.IdentityProviderOAuthSetting.wrap(buildAwsValue())
}
object IdentityProviderOAuthSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.IdentityProviderOAuthSetting =
      zio.aws.sagemaker.model.IdentityProviderOAuthSetting(
        dataSourceName.map(value => value),
        status.map(value => value),
        secretArn.map(value => value)
      )
    def dataSourceName: Optional[zio.aws.sagemaker.model.DataSourceName]
    def status: Optional[zio.aws.sagemaker.model.FeatureStatus]
    def secretArn: Optional[SecretArn]
    def getDataSourceName
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DataSourceName] =
      AwsError.unwrapOptionField("dataSourceName", dataSourceName)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting
  ) extends zio.aws.sagemaker.model.IdentityProviderOAuthSetting.ReadOnly {
    override val dataSourceName
        : Optional[zio.aws.sagemaker.model.DataSourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSourceName())
        .map(value => zio.aws.sagemaker.model.DataSourceName.wrap(value))
    override val status: Optional[zio.aws.sagemaker.model.FeatureStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.FeatureStatus.wrap(value))
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.sagemaker.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.IdentityProviderOAuthSetting
  ): zio.aws.sagemaker.model.IdentityProviderOAuthSetting.ReadOnly =
    new Wrapper(impl)
}
