package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.CountryCode
import scala.jdk.CollectionConverters.*
final case class HolidayConfigAttributes(
    countryCode: Optional[CountryCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HolidayConfigAttributes = {
    import HolidayConfigAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HolidayConfigAttributes
      .builder()
      .optionallyWith(
        countryCode.map(value => CountryCode.unwrap(value): java.lang.String)
      )(_.countryCode)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HolidayConfigAttributes.ReadOnly =
    zio.aws.sagemaker.model.HolidayConfigAttributes.wrap(buildAwsValue())
}
object HolidayConfigAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HolidayConfigAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HolidayConfigAttributes =
      zio.aws.sagemaker.model
        .HolidayConfigAttributes(countryCode.map(value => value))
    def countryCode: Optional[CountryCode]
    def getCountryCode: ZIO[Any, AwsError, CountryCode] =
      AwsError.unwrapOptionField("countryCode", countryCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HolidayConfigAttributes
  ) extends zio.aws.sagemaker.model.HolidayConfigAttributes.ReadOnly {
    override val countryCode: Optional[CountryCode] = zio.aws.core.internal
      .optionalFromNullable(impl.countryCode())
      .map(value => zio.aws.sagemaker.model.primitives.CountryCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HolidayConfigAttributes
  ): zio.aws.sagemaker.model.HolidayConfigAttributes.ReadOnly = new Wrapper(
    impl
  )
}
