package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  CustomerMetadataValue,
  Timestamp,
  CustomerMetadataKey,
  CertifyForMarketplace,
  ApprovalDescription,
  ModelPackageVersion,
  ModelPackageArn,
  EntityDescription,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeModelPackageResponse(
    modelPackageName: EntityName,
    modelPackageGroupName: Optional[EntityName] = Optional.Absent,
    modelPackageVersion: Optional[ModelPackageVersion] = Optional.Absent,
    modelPackageArn: ModelPackageArn,
    modelPackageDescription: Optional[EntityDescription] = Optional.Absent,
    creationTime: CreationTime,
    inferenceSpecification: Optional[
      zio.aws.sagemaker.model.InferenceSpecification
    ] = Optional.Absent,
    sourceAlgorithmSpecification: Optional[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification
    ] = Optional.Absent,
    validationSpecification: Optional[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification
    ] = Optional.Absent,
    modelPackageStatus: zio.aws.sagemaker.model.ModelPackageStatus,
    modelPackageStatusDetails: zio.aws.sagemaker.model.ModelPackageStatusDetails,
    certifyForMarketplace: Optional[CertifyForMarketplace] = Optional.Absent,
    modelApprovalStatus: Optional[zio.aws.sagemaker.model.ModelApprovalStatus] =
      Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    modelMetrics: Optional[zio.aws.sagemaker.model.ModelMetrics] =
      Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    approvalDescription: Optional[ApprovalDescription] = Optional.Absent,
    customerMetadataProperties: Optional[
      Map[CustomerMetadataKey, CustomerMetadataValue]
    ] = Optional.Absent,
    driftCheckBaselines: Optional[zio.aws.sagemaker.model.DriftCheckBaselines] =
      Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    task: Optional[String] = Optional.Absent,
    samplePayloadUrl: Optional[String] = Optional.Absent,
    additionalInferenceSpecifications: Optional[Iterable[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
    ]] = Optional.Absent,
    skipModelValidation: Optional[zio.aws.sagemaker.model.SkipModelValidation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse = {
    import DescribeModelPackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse
      .builder()
      .modelPackageName(EntityName.unwrap(modelPackageName): java.lang.String)
      .optionallyWith(
        modelPackageGroupName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(
        modelPackageVersion.map(value =>
          ModelPackageVersion.unwrap(value): Integer
        )
      )(_.modelPackageVersion)
      .modelPackageArn(
        ModelPackageArn.unwrap(modelPackageArn): java.lang.String
      )
      .optionallyWith(
        modelPackageDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        inferenceSpecification.map(value => value.buildAwsValue())
      )(_.inferenceSpecification)
      .optionallyWith(
        sourceAlgorithmSpecification.map(value => value.buildAwsValue())
      )(_.sourceAlgorithmSpecification)
      .optionallyWith(
        validationSpecification.map(value => value.buildAwsValue())
      )(_.validationSpecification)
      .modelPackageStatus(modelPackageStatus.unwrap)
      .modelPackageStatusDetails(modelPackageStatusDetails.buildAwsValue())
      .optionallyWith(
        certifyForMarketplace.map(value =>
          CertifyForMarketplace.unwrap(value): java.lang.Boolean
        )
      )(_.certifyForMarketplace)
      .optionallyWith(modelApprovalStatus.map(value => value.unwrap))(
        _.modelApprovalStatus
      )
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(modelMetrics.map(value => value.buildAwsValue()))(
        _.modelMetrics
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        approvalDescription.map(value =>
          ApprovalDescription.unwrap(value): java.lang.String
        )
      )(_.approvalDescription)
      .optionallyWith(
        customerMetadataProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomerMetadataKey.unwrap(
                key
              ): java.lang.String) -> (CustomerMetadataValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.customerMetadataProperties)
      .optionallyWith(driftCheckBaselines.map(value => value.buildAwsValue()))(
        _.driftCheckBaselines
      )
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(samplePayloadUrl.map(value => value: java.lang.String))(
        _.samplePayloadUrl
      )
      .optionallyWith(
        additionalInferenceSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalInferenceSpecifications)
      .optionallyWith(skipModelValidation.map(value => value.unwrap))(
        _.skipModelValidation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelPackageResponse.wrap(buildAwsValue())
}
object DescribeModelPackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelPackageResponse =
      zio.aws.sagemaker.model.DescribeModelPackageResponse(
        modelPackageName,
        modelPackageGroupName.map(value => value),
        modelPackageVersion.map(value => value),
        modelPackageArn,
        modelPackageDescription.map(value => value),
        creationTime,
        inferenceSpecification.map(value => value.asEditable),
        sourceAlgorithmSpecification.map(value => value.asEditable),
        validationSpecification.map(value => value.asEditable),
        modelPackageStatus,
        modelPackageStatusDetails.asEditable,
        certifyForMarketplace.map(value => value),
        modelApprovalStatus.map(value => value),
        createdBy.map(value => value.asEditable),
        metadataProperties.map(value => value.asEditable),
        modelMetrics.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        approvalDescription.map(value => value),
        customerMetadataProperties.map(value => value),
        driftCheckBaselines.map(value => value.asEditable),
        domain.map(value => value),
        task.map(value => value),
        samplePayloadUrl.map(value => value),
        additionalInferenceSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        skipModelValidation.map(value => value)
      )
    def modelPackageName: EntityName
    def modelPackageGroupName: Optional[EntityName]
    def modelPackageVersion: Optional[ModelPackageVersion]
    def modelPackageArn: ModelPackageArn
    def modelPackageDescription: Optional[EntityDescription]
    def creationTime: CreationTime
    def inferenceSpecification
        : Optional[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly]
    def sourceAlgorithmSpecification: Optional[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ]
    def validationSpecification: Optional[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ]
    def modelPackageStatus: zio.aws.sagemaker.model.ModelPackageStatus
    def modelPackageStatusDetails
        : zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly
    def certifyForMarketplace: Optional[CertifyForMarketplace]
    def modelApprovalStatus
        : Optional[zio.aws.sagemaker.model.ModelApprovalStatus]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def modelMetrics: Optional[zio.aws.sagemaker.model.ModelMetrics.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def approvalDescription: Optional[ApprovalDescription]
    def customerMetadataProperties
        : Optional[Map[CustomerMetadataKey, CustomerMetadataValue]]
    def driftCheckBaselines
        : Optional[zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly]
    def domain: Optional[String]
    def task: Optional[String]
    def samplePayloadUrl: Optional[String]
    def additionalInferenceSpecifications: Optional[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]]
    def skipModelValidation
        : Optional[zio.aws.sagemaker.model.SkipModelValidation]
    def getModelPackageName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageName)
    def getModelPackageGroupName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getModelPackageVersion: ZIO[Any, AwsError, ModelPackageVersion] =
      AwsError.unwrapOptionField("modelPackageVersion", modelPackageVersion)
    def getModelPackageArn: ZIO[Any, Nothing, ModelPackageArn] =
      ZIO.succeed(modelPackageArn)
    def getModelPackageDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageDescription",
        modelPackageDescription
      )
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getInferenceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceSpecification",
      inferenceSpecification
    )
    def getSourceAlgorithmSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceAlgorithmSpecification",
      sourceAlgorithmSpecification
    )
    def getValidationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "validationSpecification",
      validationSpecification
    )
    def getModelPackageStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelPackageStatus] =
      ZIO.succeed(modelPackageStatus)
    def getModelPackageStatusDetails: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly
    ] = ZIO.succeed(modelPackageStatusDetails)
    def getCertifyForMarketplace: ZIO[Any, AwsError, CertifyForMarketplace] =
      AwsError.unwrapOptionField("certifyForMarketplace", certifyForMarketplace)
    def getModelApprovalStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelApprovalStatus] =
      AwsError.unwrapOptionField("modelApprovalStatus", modelApprovalStatus)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getModelMetrics
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelMetrics.ReadOnly] =
      AwsError.unwrapOptionField("modelMetrics", modelMetrics)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getApprovalDescription: ZIO[Any, AwsError, ApprovalDescription] =
      AwsError.unwrapOptionField("approvalDescription", approvalDescription)
    def getCustomerMetadataProperties
        : ZIO[Any, AwsError, Map[CustomerMetadataKey, CustomerMetadataValue]] =
      AwsError.unwrapOptionField(
        "customerMetadataProperties",
        customerMetadataProperties
      )
    def getDriftCheckBaselines: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly
    ] = AwsError.unwrapOptionField("driftCheckBaselines", driftCheckBaselines)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getSamplePayloadUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("samplePayloadUrl", samplePayloadUrl)
    def getAdditionalInferenceSpecifications: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalInferenceSpecifications",
      additionalInferenceSpecifications
    )
    def getSkipModelValidation
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SkipModelValidation] =
      AwsError.unwrapOptionField("skipModelValidation", skipModelValidation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse
  ) extends zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly {
    override val modelPackageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelPackageName())
    override val modelPackageGroupName: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageGroupName())
        .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelPackageVersion: Optional[ModelPackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageVersion())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ModelPackageVersion(value)
        )
    override val modelPackageArn: ModelPackageArn =
      zio.aws.sagemaker.model.primitives.ModelPackageArn(impl.modelPackageArn())
    override val modelPackageDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val inferenceSpecification
        : Optional[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceSpecification())
        .map(value =>
          zio.aws.sagemaker.model.InferenceSpecification.wrap(value)
        )
    override val sourceAlgorithmSpecification: Optional[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAlgorithmSpecification())
      .map(value =>
        zio.aws.sagemaker.model.SourceAlgorithmSpecification.wrap(value)
      )
    override val validationSpecification: Optional[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validationSpecification())
      .map(value =>
        zio.aws.sagemaker.model.ModelPackageValidationSpecification.wrap(value)
      )
    override val modelPackageStatus
        : zio.aws.sagemaker.model.ModelPackageStatus =
      zio.aws.sagemaker.model.ModelPackageStatus.wrap(impl.modelPackageStatus())
    override val modelPackageStatusDetails
        : zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly =
      zio.aws.sagemaker.model.ModelPackageStatusDetails
        .wrap(impl.modelPackageStatusDetails())
    override val certifyForMarketplace: Optional[CertifyForMarketplace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certifyForMarketplace())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CertifyForMarketplace(value)
        )
    override val modelApprovalStatus
        : Optional[zio.aws.sagemaker.model.ModelApprovalStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelApprovalStatus())
        .map(value => zio.aws.sagemaker.model.ModelApprovalStatus.wrap(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val modelMetrics
        : Optional[zio.aws.sagemaker.model.ModelMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelMetrics())
        .map(value => zio.aws.sagemaker.model.ModelMetrics.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val approvalDescription: Optional[ApprovalDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ApprovalDescription(value)
        )
    override val customerMetadataProperties
        : Optional[Map[CustomerMetadataKey, CustomerMetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerMetadataProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives
                .CustomerMetadataKey(key) -> zio.aws.sagemaker.model.primitives
                .CustomerMetadataValue(value)
            })
            .toMap
        )
    override val driftCheckBaselines
        : Optional[zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driftCheckBaselines())
        .map(value => zio.aws.sagemaker.model.DriftCheckBaselines.wrap(value))
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val task: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.task())
      .map(value => value: String)
    override val samplePayloadUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.samplePayloadUrl())
      .map(value => value: String)
    override val additionalInferenceSpecifications: Optional[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInferenceSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
            .wrap(item)
        }.toList
      )
    override val skipModelValidation
        : Optional[zio.aws.sagemaker.model.SkipModelValidation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skipModelValidation())
        .map(value => zio.aws.sagemaker.model.SkipModelValidation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse
  ): zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly =
    new Wrapper(impl)
}
