package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointConfigName
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointConfigRequest(
    endpointConfigName: EndpointConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest = {
    import DescribeEndpointConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest
      .builder()
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeEndpointConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeEndpointConfigRequest.wrap(buildAwsValue())
}
object DescribeEndpointConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEndpointConfigRequest =
      zio.aws.sagemaker.model.DescribeEndpointConfigRequest(endpointConfigName)
    def endpointConfigName: EndpointConfigName
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest
  ) extends zio.aws.sagemaker.model.DescribeEndpointConfigRequest.ReadOnly {
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest
  ): zio.aws.sagemaker.model.DescribeEndpointConfigRequest.ReadOnly =
    new Wrapper(impl)
}
