package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  StudioLifecycleConfigContent,
  StudioLifecycleConfigName
}
import scala.jdk.CollectionConverters.*
final case class CreateStudioLifecycleConfigRequest(
    studioLifecycleConfigName: StudioLifecycleConfigName,
    studioLifecycleConfigContent: StudioLifecycleConfigContent,
    studioLifecycleConfigAppType: zio.aws.sagemaker.model.StudioLifecycleConfigAppType,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest = {
    import CreateStudioLifecycleConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest
      .builder()
      .studioLifecycleConfigName(
        StudioLifecycleConfigName.unwrap(
          studioLifecycleConfigName
        ): java.lang.String
      )
      .studioLifecycleConfigContent(
        StudioLifecycleConfigContent.unwrap(
          studioLifecycleConfigContent
        ): java.lang.String
      )
      .studioLifecycleConfigAppType(studioLifecycleConfigAppType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateStudioLifecycleConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateStudioLifecycleConfigRequest
      .wrap(buildAwsValue())
}
object CreateStudioLifecycleConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateStudioLifecycleConfigRequest =
      zio.aws.sagemaker.model.CreateStudioLifecycleConfigRequest(
        studioLifecycleConfigName,
        studioLifecycleConfigContent,
        studioLifecycleConfigAppType,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def studioLifecycleConfigName: StudioLifecycleConfigName
    def studioLifecycleConfigContent: StudioLifecycleConfigContent
    def studioLifecycleConfigAppType
        : zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getStudioLifecycleConfigName
        : ZIO[Any, Nothing, StudioLifecycleConfigName] =
      ZIO.succeed(studioLifecycleConfigName)
    def getStudioLifecycleConfigContent
        : ZIO[Any, Nothing, StudioLifecycleConfigContent] =
      ZIO.succeed(studioLifecycleConfigContent)
    def getStudioLifecycleConfigAppType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = ZIO.succeed(studioLifecycleConfigAppType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest
  ) extends zio.aws.sagemaker.model.CreateStudioLifecycleConfigRequest.ReadOnly {
    override val studioLifecycleConfigName: StudioLifecycleConfigName =
      zio.aws.sagemaker.model.primitives
        .StudioLifecycleConfigName(impl.studioLifecycleConfigName())
    override val studioLifecycleConfigContent: StudioLifecycleConfigContent =
      zio.aws.sagemaker.model.primitives
        .StudioLifecycleConfigContent(impl.studioLifecycleConfigContent())
    override val studioLifecycleConfigAppType
        : zio.aws.sagemaker.model.StudioLifecycleConfigAppType =
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
        .wrap(impl.studioLifecycleConfigAppType())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest
  ): zio.aws.sagemaker.model.CreateStudioLifecycleConfigRequest.ReadOnly =
    new Wrapper(impl)
}
