package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{RoleArn, AutoMLJobName}
import scala.jdk.CollectionConverters.*
final case class CreateAutoMlJobV2Request(
    autoMLJobName: AutoMLJobName,
    autoMLJobInputDataConfig: Iterable[
      zio.aws.sagemaker.model.AutoMLJobChannel
    ],
    outputDataConfig: zio.aws.sagemaker.model.AutoMLOutputDataConfig,
    autoMLProblemTypeConfig: zio.aws.sagemaker.model.AutoMLProblemTypeConfig,
    roleArn: RoleArn,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    securityConfig: Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig] =
      Optional.Absent,
    autoMLJobObjective: Optional[zio.aws.sagemaker.model.AutoMLJobObjective] =
      Optional.Absent,
    modelDeployConfig: Optional[zio.aws.sagemaker.model.ModelDeployConfig] =
      Optional.Absent,
    dataSplitConfig: Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request = {
    import CreateAutoMlJobV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .autoMLJobInputDataConfig(autoMLJobInputDataConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .autoMLProblemTypeConfig(autoMLProblemTypeConfig.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(securityConfig.map(value => value.buildAwsValue()))(
        _.securityConfig
      )
      .optionallyWith(autoMLJobObjective.map(value => value.buildAwsValue()))(
        _.autoMLJobObjective
      )
      .optionallyWith(modelDeployConfig.map(value => value.buildAwsValue()))(
        _.modelDeployConfig
      )
      .optionallyWith(dataSplitConfig.map(value => value.buildAwsValue()))(
        _.dataSplitConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateAutoMlJobV2Request.ReadOnly =
    zio.aws.sagemaker.model.CreateAutoMlJobV2Request.wrap(buildAwsValue())
}
object CreateAutoMlJobV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAutoMlJobV2Request =
      zio.aws.sagemaker.model.CreateAutoMlJobV2Request(
        autoMLJobName,
        autoMLJobInputDataConfig.map { item =>
          item.asEditable
        },
        outputDataConfig.asEditable,
        autoMLProblemTypeConfig.asEditable,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityConfig.map(value => value.asEditable),
        autoMLJobObjective.map(value => value.asEditable),
        modelDeployConfig.map(value => value.asEditable),
        dataSplitConfig.map(value => value.asEditable)
      )
    def autoMLJobName: AutoMLJobName
    def autoMLJobInputDataConfig
        : List[zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly]
    def outputDataConfig
        : zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly
    def autoMLProblemTypeConfig
        : zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly
    def roleArn: RoleArn
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def securityConfig
        : Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly]
    def autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly]
    def modelDeployConfig
        : Optional[zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly]
    def dataSplitConfig
        : Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly]
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
    def getAutoMLJobInputDataConfig: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly
    ]] = ZIO.succeed(autoMLJobInputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getAutoMLProblemTypeConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly
    ] = ZIO.succeed(autoMLProblemTypeConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecurityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("securityConfig", securityConfig)
    def getAutoMLJobObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobObjective", autoMLJobObjective)
    def getModelDeployConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly
    ] = AwsError.unwrapOptionField("modelDeployConfig", modelDeployConfig)
    def getDataSplitConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataSplitConfig", dataSplitConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request
  ) extends zio.aws.sagemaker.model.CreateAutoMlJobV2Request.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
    override val autoMLJobInputDataConfig
        : List[zio.aws.sagemaker.model.AutoMLJobChannel.ReadOnly] = impl
      .autoMLJobInputDataConfig()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AutoMLJobChannel.wrap(item)
      }
      .toList
    override val outputDataConfig
        : zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly =
      zio.aws.sagemaker.model.AutoMLOutputDataConfig
        .wrap(impl.outputDataConfig())
    override val autoMLProblemTypeConfig
        : zio.aws.sagemaker.model.AutoMLProblemTypeConfig.ReadOnly =
      zio.aws.sagemaker.model.AutoMLProblemTypeConfig
        .wrap(impl.autoMLProblemTypeConfig())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val securityConfig
        : Optional[zio.aws.sagemaker.model.AutoMLSecurityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfig())
        .map(value => zio.aws.sagemaker.model.AutoMLSecurityConfig.wrap(value))
    override val autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLJobObjective())
        .map(value => zio.aws.sagemaker.model.AutoMLJobObjective.wrap(value))
    override val modelDeployConfig
        : Optional[zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDeployConfig())
        .map(value => zio.aws.sagemaker.model.ModelDeployConfig.wrap(value))
    override val dataSplitConfig
        : Optional[zio.aws.sagemaker.model.AutoMLDataSplitConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSplitConfig())
        .map(value => zio.aws.sagemaker.model.AutoMLDataSplitConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request
  ): zio.aws.sagemaker.model.CreateAutoMlJobV2Request.ReadOnly = new Wrapper(
    impl
  )
}
