package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{SpaceName, DomainId}
import scala.jdk.CollectionConverters.*
final case class UpdateSpaceRequest(
    domainId: DomainId,
    spaceName: SpaceName,
    spaceSettings: Optional[zio.aws.sagemaker.model.SpaceSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateSpaceRequest = {
    import UpdateSpaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateSpaceRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .spaceName(SpaceName.unwrap(spaceName): java.lang.String)
      .optionallyWith(spaceSettings.map(value => value.buildAwsValue()))(
        _.spaceSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateSpaceRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateSpaceRequest.wrap(buildAwsValue())
}
object UpdateSpaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateSpaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateSpaceRequest =
      zio.aws.sagemaker.model.UpdateSpaceRequest(
        domainId,
        spaceName,
        spaceSettings.map(value => value.asEditable)
      )
    def domainId: DomainId
    def spaceName: SpaceName
    def spaceSettings: Optional[zio.aws.sagemaker.model.SpaceSettings.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getSpaceName: ZIO[Any, Nothing, SpaceName] = ZIO.succeed(spaceName)
    def getSpaceSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SpaceSettings.ReadOnly] =
      AwsError.unwrapOptionField("spaceSettings", spaceSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateSpaceRequest
  ) extends zio.aws.sagemaker.model.UpdateSpaceRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val spaceName: SpaceName =
      zio.aws.sagemaker.model.primitives.SpaceName(impl.spaceName())
    override val spaceSettings
        : Optional[zio.aws.sagemaker.model.SpaceSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spaceSettings())
        .map(value => zio.aws.sagemaker.model.SpaceSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateSpaceRequest
  ): zio.aws.sagemaker.model.UpdateSpaceRequest.ReadOnly = new Wrapper(impl)
}
