package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  MonitoringEvaluationPeriod,
  MonitoringDatapointsToAlert,
  MonitoringAlertName,
  MonitoringScheduleName
}
import scala.jdk.CollectionConverters.*
final case class UpdateMonitoringAlertRequest(
    monitoringScheduleName: MonitoringScheduleName,
    monitoringAlertName: MonitoringAlertName,
    datapointsToAlert: MonitoringDatapointsToAlert,
    evaluationPeriod: MonitoringEvaluationPeriod
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertRequest = {
    import UpdateMonitoringAlertRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertRequest
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .monitoringAlertName(
        MonitoringAlertName.unwrap(monitoringAlertName): java.lang.String
      )
      .datapointsToAlert(
        MonitoringDatapointsToAlert.unwrap(datapointsToAlert): Integer
      )
      .evaluationPeriod(
        MonitoringEvaluationPeriod.unwrap(evaluationPeriod): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.UpdateMonitoringAlertRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateMonitoringAlertRequest.wrap(buildAwsValue())
}
object UpdateMonitoringAlertRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateMonitoringAlertRequest =
      zio.aws.sagemaker.model.UpdateMonitoringAlertRequest(
        monitoringScheduleName,
        monitoringAlertName,
        datapointsToAlert,
        evaluationPeriod
      )
    def monitoringScheduleName: MonitoringScheduleName
    def monitoringAlertName: MonitoringAlertName
    def datapointsToAlert: MonitoringDatapointsToAlert
    def evaluationPeriod: MonitoringEvaluationPeriod
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
    def getMonitoringAlertName: ZIO[Any, Nothing, MonitoringAlertName] =
      ZIO.succeed(monitoringAlertName)
    def getDatapointsToAlert: ZIO[Any, Nothing, MonitoringDatapointsToAlert] =
      ZIO.succeed(datapointsToAlert)
    def getEvaluationPeriod: ZIO[Any, Nothing, MonitoringEvaluationPeriod] =
      ZIO.succeed(evaluationPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertRequest
  ) extends zio.aws.sagemaker.model.UpdateMonitoringAlertRequest.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
    override val monitoringAlertName: MonitoringAlertName =
      zio.aws.sagemaker.model.primitives
        .MonitoringAlertName(impl.monitoringAlertName())
    override val datapointsToAlert: MonitoringDatapointsToAlert =
      zio.aws.sagemaker.model.primitives
        .MonitoringDatapointsToAlert(impl.datapointsToAlert())
    override val evaluationPeriod: MonitoringEvaluationPeriod =
      zio.aws.sagemaker.model.primitives
        .MonitoringEvaluationPeriod(impl.evaluationPeriod())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertRequest
  ): zio.aws.sagemaker.model.UpdateMonitoringAlertRequest.ReadOnly =
    new Wrapper(impl)
}
