package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.DomainId
import scala.jdk.CollectionConverters.*
final case class UpdateDomainRequest(
    domainId: DomainId,
    defaultUserSettings: Optional[zio.aws.sagemaker.model.UserSettings] =
      Optional.Absent,
    domainSettingsForUpdate: Optional[
      zio.aws.sagemaker.model.DomainSettingsForUpdate
    ] = Optional.Absent,
    defaultSpaceSettings: Optional[
      zio.aws.sagemaker.model.DefaultSpaceSettings
    ] = Optional.Absent,
    appSecurityGroupManagement: Optional[
      zio.aws.sagemaker.model.AppSecurityGroupManagement
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest = {
    import UpdateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(defaultUserSettings.map(value => value.buildAwsValue()))(
        _.defaultUserSettings
      )
      .optionallyWith(
        domainSettingsForUpdate.map(value => value.buildAwsValue())
      )(_.domainSettingsForUpdate)
      .optionallyWith(defaultSpaceSettings.map(value => value.buildAwsValue()))(
        _.defaultSpaceSettings
      )
      .optionallyWith(appSecurityGroupManagement.map(value => value.unwrap))(
        _.appSecurityGroupManagement
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateDomainRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateDomainRequest.wrap(buildAwsValue())
}
object UpdateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateDomainRequest =
      zio.aws.sagemaker.model.UpdateDomainRequest(
        domainId,
        defaultUserSettings.map(value => value.asEditable),
        domainSettingsForUpdate.map(value => value.asEditable),
        defaultSpaceSettings.map(value => value.asEditable),
        appSecurityGroupManagement.map(value => value)
      )
    def domainId: DomainId
    def defaultUserSettings
        : Optional[zio.aws.sagemaker.model.UserSettings.ReadOnly]
    def domainSettingsForUpdate
        : Optional[zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly]
    def defaultSpaceSettings
        : Optional[zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly]
    def appSecurityGroupManagement
        : Optional[zio.aws.sagemaker.model.AppSecurityGroupManagement]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getDefaultUserSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      AwsError.unwrapOptionField("defaultUserSettings", defaultUserSettings)
    def getDomainSettingsForUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "domainSettingsForUpdate",
      domainSettingsForUpdate
    )
    def getDefaultSpaceSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly
    ] = AwsError.unwrapOptionField("defaultSpaceSettings", defaultSpaceSettings)
    def getAppSecurityGroupManagement: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AppSecurityGroupManagement
    ] = AwsError.unwrapOptionField(
      "appSecurityGroupManagement",
      appSecurityGroupManagement
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest
  ) extends zio.aws.sagemaker.model.UpdateDomainRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val defaultUserSettings
        : Optional[zio.aws.sagemaker.model.UserSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultUserSettings())
        .map(value => zio.aws.sagemaker.model.UserSettings.wrap(value))
    override val domainSettingsForUpdate
        : Optional[zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainSettingsForUpdate())
        .map(value =>
          zio.aws.sagemaker.model.DomainSettingsForUpdate.wrap(value)
        )
    override val defaultSpaceSettings
        : Optional[zio.aws.sagemaker.model.DefaultSpaceSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSpaceSettings())
        .map(value => zio.aws.sagemaker.model.DefaultSpaceSettings.wrap(value))
    override val appSecurityGroupManagement
        : Optional[zio.aws.sagemaker.model.AppSecurityGroupManagement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appSecurityGroupManagement())
        .map(value =>
          zio.aws.sagemaker.model.AppSecurityGroupManagement.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest
  ): zio.aws.sagemaker.model.UpdateDomainRequest.ReadOnly = new Wrapper(impl)
}
