package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ExperimentEntityName,
  TrialArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TrialSummary(
    trialArn: Optional[TrialArn] = Optional.Absent,
    trialName: Optional[ExperimentEntityName] = Optional.Absent,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    trialSource: Optional[zio.aws.sagemaker.model.TrialSource] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialSummary = {
    import TrialSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialSummary
      .builder()
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(trialSource.map(value => value.buildAwsValue()))(
        _.trialSource
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialSummary.ReadOnly =
    zio.aws.sagemaker.model.TrialSummary.wrap(buildAwsValue())
}
object TrialSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialSummary =
      zio.aws.sagemaker.model.TrialSummary(
        trialArn.map(value => value),
        trialName.map(value => value),
        displayName.map(value => value),
        trialSource.map(value => value.asEditable),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def trialArn: Optional[TrialArn]
    def trialName: Optional[ExperimentEntityName]
    def displayName: Optional[ExperimentEntityName]
    def trialSource: Optional[zio.aws.sagemaker.model.TrialSource.ReadOnly]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getTrialSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrialSource.ReadOnly] =
      AwsError.unwrapOptionField("trialSource", trialSource)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialSummary
  ) extends zio.aws.sagemaker.model.TrialSummary.ReadOnly {
    override val trialArn: Optional[TrialArn] = zio.aws.core.internal
      .optionalFromNullable(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
    override val trialName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialSource
        : Optional[zio.aws.sagemaker.model.TrialSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialSource())
        .map(value => zio.aws.sagemaker.model.TrialSource.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialSummary
  ): zio.aws.sagemaker.model.TrialSummary.ReadOnly = new Wrapper(impl)
}
