package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{TargetLabelColumn, ContentColumn}
import scala.jdk.CollectionConverters.*
final case class TextClassificationJobConfig(
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent,
    contentColumn: Optional[ContentColumn] = Optional.Absent,
    targetLabelColumn: Optional[TargetLabelColumn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig = {
    import TextClassificationJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig
      .builder()
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .optionallyWith(
        contentColumn.map(value =>
          ContentColumn.unwrap(value): java.lang.String
        )
      )(_.contentColumn)
      .optionallyWith(
        targetLabelColumn.map(value =>
          TargetLabelColumn.unwrap(value): java.lang.String
        )
      )(_.targetLabelColumn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly =
    zio.aws.sagemaker.model.TextClassificationJobConfig.wrap(buildAwsValue())
}
object TextClassificationJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TextClassificationJobConfig =
      zio.aws.sagemaker.model.TextClassificationJobConfig(
        completionCriteria.map(value => value.asEditable),
        contentColumn.map(value => value),
        targetLabelColumn.map(value => value)
      )
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def contentColumn: Optional[ContentColumn]
    def targetLabelColumn: Optional[TargetLabelColumn]
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
    def getContentColumn: ZIO[Any, AwsError, ContentColumn] =
      AwsError.unwrapOptionField("contentColumn", contentColumn)
    def getTargetLabelColumn: ZIO[Any, AwsError, TargetLabelColumn] =
      AwsError.unwrapOptionField("targetLabelColumn", targetLabelColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig
  ) extends zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly {
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
    override val contentColumn: Optional[ContentColumn] = zio.aws.core.internal
      .optionalFromNullable(impl.contentColumn())
      .map(value => zio.aws.sagemaker.model.primitives.ContentColumn(value))
    override val targetLabelColumn: Optional[TargetLabelColumn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLabelColumn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TargetLabelColumn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig
  ): zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly = new Wrapper(
    impl
  )
}
