package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringScheduleName
import scala.jdk.CollectionConverters.*
final case class StartMonitoringScheduleRequest(
    monitoringScheduleName: MonitoringScheduleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest = {
    import StartMonitoringScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StartMonitoringScheduleRequest.ReadOnly =
    zio.aws.sagemaker.model.StartMonitoringScheduleRequest.wrap(buildAwsValue())
}
object StartMonitoringScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StartMonitoringScheduleRequest =
      zio.aws.sagemaker.model
        .StartMonitoringScheduleRequest(monitoringScheduleName)
    def monitoringScheduleName: MonitoringScheduleName
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest
  ) extends zio.aws.sagemaker.model.StartMonitoringScheduleRequest.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest
  ): zio.aws.sagemaker.model.StartMonitoringScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
