package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait SecondaryStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.SecondaryStatus
}
object SecondaryStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.SecondaryStatus
  ): zio.aws.sagemaker.model.SecondaryStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.STARTING =>
      val r = Starting
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.LAUNCHING_ML_INSTANCES =>
      val r = LaunchingMLInstances
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.PREPARING_TRAINING_STACK =>
      val r = PreparingTrainingStack
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.DOWNLOADING =>
      val r = Downloading
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.DOWNLOADING_TRAINING_IMAGE =>
      val r = DownloadingTrainingImage
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.TRAINING =>
      val r = Training
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.UPLOADING =>
      val r = Uploading
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.MAX_RUNTIME_EXCEEDED =>
      val r = MaxRuntimeExceeded
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.INTERRUPTED =>
      val r = Interrupted
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.MAX_WAIT_TIME_EXCEEDED =>
      val r = MaxWaitTimeExceeded
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.RESTARTING =>
      val r = Restarting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Starting extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.STARTING
  }
  case object LaunchingMLInstances
      extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.LAUNCHING_ML_INSTANCES
  }
  case object PreparingTrainingStack
      extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.PREPARING_TRAINING_STACK
  }
  case object Downloading extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.DOWNLOADING
  }
  case object DownloadingTrainingImage
      extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.DOWNLOADING_TRAINING_IMAGE
  }
  case object Training extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.TRAINING
  }
  case object Uploading extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.UPLOADING
  }
  case object Stopping extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.STOPPED
  }
  case object MaxRuntimeExceeded
      extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.MAX_RUNTIME_EXCEEDED
  }
  case object Completed extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.FAILED
  }
  case object Interrupted extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.INTERRUPTED
  }
  case object MaxWaitTimeExceeded
      extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.MAX_WAIT_TIME_EXCEEDED
  }
  case object Updating extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.UPDATING
  }
  case object Restarting extends zio.aws.sagemaker.model.SecondaryStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SecondaryStatus =
      software.amazon.awssdk.services.sagemaker.model.SecondaryStatus.RESTARTING
  }
}
