package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait NotebookInstanceStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus
}
object NotebookInstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus
  ): zio.aws.sagemaker.model.NotebookInstanceStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.UPDATING =>
      val r = Updating
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.NotebookInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.sagemaker.model.NotebookInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.PENDING
  }
  case object InService extends zio.aws.sagemaker.model.NotebookInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.IN_SERVICE
  }
  case object Stopping extends zio.aws.sagemaker.model.NotebookInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.NotebookInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.STOPPED
  }
  case object Failed extends zio.aws.sagemaker.model.NotebookInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.FAILED
  }
  case object Deleting extends zio.aws.sagemaker.model.NotebookInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.DELETING
  }
  case object Updating extends zio.aws.sagemaker.model.NotebookInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus =
      software.amazon.awssdk.services.sagemaker.model.NotebookInstanceStatus.UPDATING
  }
}
