package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait MonitoringAlertStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus
}
object MonitoringAlertStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus
  ): zio.aws.sagemaker.model.MonitoringAlertStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus.IN_ALERT =>
      val r = InAlert
      r
    case software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus.OK =>
      val r = OK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.MonitoringAlertStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus =
      software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InAlert extends zio.aws.sagemaker.model.MonitoringAlertStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus =
      software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus.IN_ALERT
  }
  case object OK extends zio.aws.sagemaker.model.MonitoringAlertStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus =
      software.amazon.awssdk.services.sagemaker.model.MonitoringAlertStatus.OK
  }
}
