package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{ModelVariantName, ModelName}
import scala.jdk.CollectionConverters.*
final case class ModelVariantConfig(
    modelName: ModelName,
    variantName: ModelVariantName,
    infrastructureConfig: zio.aws.sagemaker.model.ModelInfrastructureConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig = {
    import ModelVariantConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .variantName(ModelVariantName.unwrap(variantName): java.lang.String)
      .infrastructureConfig(infrastructureConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly =
    zio.aws.sagemaker.model.ModelVariantConfig.wrap(buildAwsValue())
}
object ModelVariantConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelVariantConfig =
      zio.aws.sagemaker.model.ModelVariantConfig(
        modelName,
        variantName,
        infrastructureConfig.asEditable
      )
    def modelName: ModelName
    def variantName: ModelVariantName
    def infrastructureConfig
        : zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getVariantName: ZIO[Any, Nothing, ModelVariantName] =
      ZIO.succeed(variantName)
    def getInfrastructureConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly
    ] = ZIO.succeed(infrastructureConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig
  ) extends zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly {
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val variantName: ModelVariantName =
      zio.aws.sagemaker.model.primitives.ModelVariantName(impl.variantName())
    override val infrastructureConfig
        : zio.aws.sagemaker.model.ModelInfrastructureConfig.ReadOnly =
      zio.aws.sagemaker.model.ModelInfrastructureConfig
        .wrap(impl.infrastructureConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelVariantConfig
  ): zio.aws.sagemaker.model.ModelVariantConfig.ReadOnly = new Wrapper(impl)
}
