package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelInfrastructureType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType
}
object ModelInfrastructureType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType
  ): zio.aws.sagemaker.model.ModelInfrastructureType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType.REAL_TIME_INFERENCE =>
      val r = RealTimeInference
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelInfrastructureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType =
      software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType.UNKNOWN_TO_SDK_VERSION
  }
  case object RealTimeInference
      extends zio.aws.sagemaker.model.ModelInfrastructureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType =
      software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType.REAL_TIME_INFERENCE
  }
}
