package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  Timestamp,
  HubContentVersion,
  HubContentName,
  MaxResults,
  DocumentSchemaVersion,
  HubName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListHubContentVersionsRequest(
    hubName: HubName,
    hubContentType: zio.aws.sagemaker.model.HubContentType,
    hubContentName: HubContentName,
    minVersion: Optional[HubContentVersion] = Optional.Absent,
    maxSchemaVersion: Optional[DocumentSchemaVersion] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.HubContentSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsRequest = {
    import ListHubContentVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsRequest
      .builder()
      .hubName(HubName.unwrap(hubName): java.lang.String)
      .hubContentType(hubContentType.unwrap)
      .hubContentName(HubContentName.unwrap(hubContentName): java.lang.String)
      .optionallyWith(
        minVersion.map(value =>
          HubContentVersion.unwrap(value): java.lang.String
        )
      )(_.minVersion)
      .optionallyWith(
        maxSchemaVersion.map(value =>
          DocumentSchemaVersion.unwrap(value): java.lang.String
        )
      )(_.maxSchemaVersion)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListHubContentVersionsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListHubContentVersionsRequest.wrap(buildAwsValue())
}
object ListHubContentVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListHubContentVersionsRequest =
      zio.aws.sagemaker.model.ListHubContentVersionsRequest(
        hubName,
        hubContentType,
        hubContentName,
        minVersion.map(value => value),
        maxSchemaVersion.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def hubName: HubName
    def hubContentType: zio.aws.sagemaker.model.HubContentType
    def hubContentName: HubContentName
    def minVersion: Optional[HubContentVersion]
    def maxSchemaVersion: Optional[DocumentSchemaVersion]
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def sortBy: Optional[zio.aws.sagemaker.model.HubContentSortBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getHubName: ZIO[Any, Nothing, HubName] = ZIO.succeed(hubName)
    def getHubContentType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HubContentType] =
      ZIO.succeed(hubContentType)
    def getHubContentName: ZIO[Any, Nothing, HubContentName] =
      ZIO.succeed(hubContentName)
    def getMinVersion: ZIO[Any, AwsError, HubContentVersion] =
      AwsError.unwrapOptionField("minVersion", minVersion)
    def getMaxSchemaVersion: ZIO[Any, AwsError, DocumentSchemaVersion] =
      AwsError.unwrapOptionField("maxSchemaVersion", maxSchemaVersion)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.HubContentSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsRequest
  ) extends zio.aws.sagemaker.model.ListHubContentVersionsRequest.ReadOnly {
    override val hubName: HubName =
      zio.aws.sagemaker.model.primitives.HubName(impl.hubName())
    override val hubContentType: zio.aws.sagemaker.model.HubContentType =
      zio.aws.sagemaker.model.HubContentType.wrap(impl.hubContentType())
    override val hubContentName: HubContentName =
      zio.aws.sagemaker.model.primitives.HubContentName(impl.hubContentName())
    override val minVersion: Optional[HubContentVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.minVersion())
      .map(value => zio.aws.sagemaker.model.primitives.HubContentVersion(value))
    override val maxSchemaVersion: Optional[DocumentSchemaVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSchemaVersion())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DocumentSchemaVersion(value)
        )
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.HubContentSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.HubContentSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsRequest
  ): zio.aws.sagemaker.model.ListHubContentVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
