package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListExperimentsRequest(
    createdAfter: Optional[Timestamp] = Optional.Absent,
    createdBefore: Optional[Timestamp] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.SortExperimentsBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest = {
    import ListExperimentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest
      .builder()
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListExperimentsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListExperimentsRequest.wrap(buildAwsValue())
}
object ListExperimentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListExperimentsRequest =
      zio.aws.sagemaker.model.ListExperimentsRequest(
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def createdAfter: Optional[Timestamp]
    def createdBefore: Optional[Timestamp]
    def sortBy: Optional[zio.aws.sagemaker.model.SortExperimentsBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SortExperimentsBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest
  ) extends zio.aws.sagemaker.model.ListExperimentsRequest.ReadOnly {
    override val createdAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.SortExperimentsBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.SortExperimentsBy.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest
  ): zio.aws.sagemaker.model.ListExperimentsRequest.ReadOnly = new Wrapper(impl)
}
