package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LabelingJobDataSource(
    s3DataSource: Optional[zio.aws.sagemaker.model.LabelingJobS3DataSource] =
      Optional.Absent,
    snsDataSource: Optional[zio.aws.sagemaker.model.LabelingJobSnsDataSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.LabelingJobDataSource = {
    import LabelingJobDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.LabelingJobDataSource
      .builder()
      .optionallyWith(s3DataSource.map(value => value.buildAwsValue()))(
        _.s3DataSource
      )
      .optionallyWith(snsDataSource.map(value => value.buildAwsValue()))(
        _.snsDataSource
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.LabelingJobDataSource.ReadOnly =
    zio.aws.sagemaker.model.LabelingJobDataSource.wrap(buildAwsValue())
}
object LabelingJobDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.LabelingJobDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.LabelingJobDataSource =
      zio.aws.sagemaker.model.LabelingJobDataSource(
        s3DataSource.map(value => value.asEditable),
        snsDataSource.map(value => value.asEditable)
      )
    def s3DataSource
        : Optional[zio.aws.sagemaker.model.LabelingJobS3DataSource.ReadOnly]
    def snsDataSource
        : Optional[zio.aws.sagemaker.model.LabelingJobSnsDataSource.ReadOnly]
    def getS3DataSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobS3DataSource.ReadOnly
    ] = AwsError.unwrapOptionField("s3DataSource", s3DataSource)
    def getSnsDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobSnsDataSource.ReadOnly
    ] = AwsError.unwrapOptionField("snsDataSource", snsDataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobDataSource
  ) extends zio.aws.sagemaker.model.LabelingJobDataSource.ReadOnly {
    override val s3DataSource
        : Optional[zio.aws.sagemaker.model.LabelingJobS3DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3DataSource())
        .map(value =>
          zio.aws.sagemaker.model.LabelingJobS3DataSource.wrap(value)
        )
    override val snsDataSource
        : Optional[zio.aws.sagemaker.model.LabelingJobSnsDataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snsDataSource())
        .map(value =>
          zio.aws.sagemaker.model.LabelingJobSnsDataSource.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.LabelingJobDataSource
  ): zio.aws.sagemaker.model.LabelingJobDataSource.ReadOnly = new Wrapper(impl)
}
