package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{Timestamp, Integer}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class HyperParameterTuningJobCompletionDetails(
    numberOfTrainingJobsObjectiveNotImproving: Optional[Integer] =
      Optional.Absent,
    convergenceDetectedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobCompletionDetails = {
    import HyperParameterTuningJobCompletionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobCompletionDetails
      .builder()
      .optionallyWith(
        numberOfTrainingJobsObjectiveNotImproving.map(value =>
          value: java.lang.Integer
        )
      )(_.numberOfTrainingJobsObjectiveNotImproving)
      .optionallyWith(
        convergenceDetectedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.convergenceDetectedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails.ReadOnly =
    zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails
      .wrap(buildAwsValue())
}
object HyperParameterTuningJobCompletionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobCompletionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails =
      zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails(
        numberOfTrainingJobsObjectiveNotImproving.map(value => value),
        convergenceDetectedTime.map(value => value)
      )
    def numberOfTrainingJobsObjectiveNotImproving: Optional[Integer]
    def convergenceDetectedTime: Optional[Timestamp]
    def getNumberOfTrainingJobsObjectiveNotImproving
        : ZIO[Any, AwsError, Integer] = AwsError.unwrapOptionField(
      "numberOfTrainingJobsObjectiveNotImproving",
      numberOfTrainingJobsObjectiveNotImproving
    )
    def getConvergenceDetectedTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("convergenceDetectedTime", convergenceDetectedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobCompletionDetails
  ) extends zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails.ReadOnly {
    override val numberOfTrainingJobsObjectiveNotImproving: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfTrainingJobsObjectiveNotImproving())
        .map(value => value: Integer)
    override val convergenceDetectedTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.convergenceDetectedTime())
        .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobCompletionDetails
  ): zio.aws.sagemaker.model.HyperParameterTuningJobCompletionDetails.ReadOnly =
    new Wrapper(impl)
}
