package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  DependencyCopyPath,
  DependencyOriginPath
}
import scala.jdk.CollectionConverters.*
final case class HubContentDependency(
    dependencyOriginPath: Optional[DependencyOriginPath] = Optional.Absent,
    dependencyCopyPath: Optional[DependencyCopyPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HubContentDependency = {
    import HubContentDependency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HubContentDependency
      .builder()
      .optionallyWith(
        dependencyOriginPath.map(value =>
          DependencyOriginPath.unwrap(value): java.lang.String
        )
      )(_.dependencyOriginPath)
      .optionallyWith(
        dependencyCopyPath.map(value =>
          DependencyCopyPath.unwrap(value): java.lang.String
        )
      )(_.dependencyCopyPath)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HubContentDependency.ReadOnly =
    zio.aws.sagemaker.model.HubContentDependency.wrap(buildAwsValue())
}
object HubContentDependency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HubContentDependency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HubContentDependency =
      zio.aws.sagemaker.model.HubContentDependency(
        dependencyOriginPath.map(value => value),
        dependencyCopyPath.map(value => value)
      )
    def dependencyOriginPath: Optional[DependencyOriginPath]
    def dependencyCopyPath: Optional[DependencyCopyPath]
    def getDependencyOriginPath: ZIO[Any, AwsError, DependencyOriginPath] =
      AwsError.unwrapOptionField("dependencyOriginPath", dependencyOriginPath)
    def getDependencyCopyPath: ZIO[Any, AwsError, DependencyCopyPath] =
      AwsError.unwrapOptionField("dependencyCopyPath", dependencyCopyPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HubContentDependency
  ) extends zio.aws.sagemaker.model.HubContentDependency.ReadOnly {
    override val dependencyOriginPath: Optional[DependencyOriginPath] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dependencyOriginPath())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DependencyOriginPath(value)
        )
    override val dependencyCopyPath: Optional[DependencyCopyPath] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dependencyCopyPath())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DependencyCopyPath(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HubContentDependency
  ): zio.aws.sagemaker.model.HubContentDependency.ReadOnly = new Wrapper(impl)
}
