package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class GetDeviceFleetReportRequest(deviceFleetName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest = {
    import GetDeviceFleetReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.GetDeviceFleetReportRequest.ReadOnly =
    zio.aws.sagemaker.model.GetDeviceFleetReportRequest.wrap(buildAwsValue())
}
object GetDeviceFleetReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GetDeviceFleetReportRequest =
      zio.aws.sagemaker.model.GetDeviceFleetReportRequest(deviceFleetName)
    def deviceFleetName: EntityName
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest
  ) extends zio.aws.sagemaker.model.GetDeviceFleetReportRequest.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest
  ): zio.aws.sagemaker.model.GetDeviceFleetReportRequest.ReadOnly = new Wrapper(
    impl
  )
}
