package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  FailureReason,
  EndpointConfigName,
  EndpointName
}
import scala.jdk.CollectionConverters.*
final case class EndpointMetadata(
    endpointName: EndpointName,
    endpointConfigName: Optional[EndpointConfigName] = Optional.Absent,
    endpointStatus: Optional[zio.aws.sagemaker.model.EndpointStatus] =
      Optional.Absent,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EndpointMetadata = {
    import EndpointMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EndpointMetadata
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .optionallyWith(
        endpointConfigName.map(value =>
          EndpointConfigName.unwrap(value): java.lang.String
        )
      )(_.endpointConfigName)
      .optionallyWith(endpointStatus.map(value => value.unwrap))(
        _.endpointStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EndpointMetadata.ReadOnly =
    zio.aws.sagemaker.model.EndpointMetadata.wrap(buildAwsValue())
}
object EndpointMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EndpointMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EndpointMetadata =
      zio.aws.sagemaker.model.EndpointMetadata(
        endpointName,
        endpointConfigName.map(value => value),
        endpointStatus.map(value => value),
        failureReason.map(value => value)
      )
    def endpointName: EndpointName
    def endpointConfigName: Optional[EndpointConfigName]
    def endpointStatus: Optional[zio.aws.sagemaker.model.EndpointStatus]
    def failureReason: Optional[FailureReason]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getEndpointConfigName: ZIO[Any, AwsError, EndpointConfigName] =
      AwsError.unwrapOptionField("endpointConfigName", endpointConfigName)
    def getEndpointStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.EndpointStatus] =
      AwsError.unwrapOptionField("endpointStatus", endpointStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointMetadata
  ) extends zio.aws.sagemaker.model.EndpointMetadata.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val endpointConfigName: Optional[EndpointConfigName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointConfigName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EndpointConfigName(value)
        )
    override val endpointStatus
        : Optional[zio.aws.sagemaker.model.EndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointStatus())
        .map(value => zio.aws.sagemaker.model.EndpointStatus.wrap(value))
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EndpointMetadata
  ): zio.aws.sagemaker.model.EndpointMetadata.ReadOnly = new Wrapper(impl)
}
