package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DriftCheckBaselines(
    bias: Optional[zio.aws.sagemaker.model.DriftCheckBias] = Optional.Absent,
    explainability: Optional[zio.aws.sagemaker.model.DriftCheckExplainability] =
      Optional.Absent,
    modelQuality: Optional[zio.aws.sagemaker.model.DriftCheckModelQuality] =
      Optional.Absent,
    modelDataQuality: Optional[
      zio.aws.sagemaker.model.DriftCheckModelDataQuality
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines = {
    import DriftCheckBaselines.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines
      .builder()
      .optionallyWith(bias.map(value => value.buildAwsValue()))(_.bias)
      .optionallyWith(explainability.map(value => value.buildAwsValue()))(
        _.explainability
      )
      .optionallyWith(modelQuality.map(value => value.buildAwsValue()))(
        _.modelQuality
      )
      .optionallyWith(modelDataQuality.map(value => value.buildAwsValue()))(
        _.modelDataQuality
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly =
    zio.aws.sagemaker.model.DriftCheckBaselines.wrap(buildAwsValue())
}
object DriftCheckBaselines {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DriftCheckBaselines =
      zio.aws.sagemaker.model.DriftCheckBaselines(
        bias.map(value => value.asEditable),
        explainability.map(value => value.asEditable),
        modelQuality.map(value => value.asEditable),
        modelDataQuality.map(value => value.asEditable)
      )
    def bias: Optional[zio.aws.sagemaker.model.DriftCheckBias.ReadOnly]
    def explainability
        : Optional[zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly]
    def modelQuality
        : Optional[zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly]
    def modelDataQuality
        : Optional[zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly]
    def getBias
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DriftCheckBias.ReadOnly] =
      AwsError.unwrapOptionField("bias", bias)
    def getExplainability: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly
    ] = AwsError.unwrapOptionField("explainability", explainability)
    def getModelQuality: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly
    ] = AwsError.unwrapOptionField("modelQuality", modelQuality)
    def getModelDataQuality: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly
    ] = AwsError.unwrapOptionField("modelDataQuality", modelDataQuality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines
  ) extends zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly {
    override val bias
        : Optional[zio.aws.sagemaker.model.DriftCheckBias.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bias())
        .map(value => zio.aws.sagemaker.model.DriftCheckBias.wrap(value))
    override val explainability
        : Optional[zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explainability())
        .map(value =>
          zio.aws.sagemaker.model.DriftCheckExplainability.wrap(value)
        )
    override val modelQuality
        : Optional[zio.aws.sagemaker.model.DriftCheckModelQuality.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelQuality())
        .map(value =>
          zio.aws.sagemaker.model.DriftCheckModelQuality.wrap(value)
        )
    override val modelDataQuality: Optional[
      zio.aws.sagemaker.model.DriftCheckModelDataQuality.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.modelDataQuality())
      .map(value =>
        zio.aws.sagemaker.model.DriftCheckModelDataQuality.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckBaselines
  ): zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly = new Wrapper(impl)
}
