package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  DeviceArn,
  ThingName,
  EdgeVersion,
  DeviceDescription,
  Timestamp,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeviceSummary(
    deviceName: EntityName,
    deviceArn: DeviceArn,
    description: Optional[DeviceDescription] = Optional.Absent,
    deviceFleetName: Optional[EntityName] = Optional.Absent,
    iotThingName: Optional[ThingName] = Optional.Absent,
    registrationTime: Optional[Timestamp] = Optional.Absent,
    latestHeartbeat: Optional[Timestamp] = Optional.Absent,
    models: Optional[Iterable[zio.aws.sagemaker.model.EdgeModelSummary]] =
      Optional.Absent,
    agentVersion: Optional[EdgeVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeviceSummary = {
    import DeviceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeviceSummary
      .builder()
      .deviceName(EntityName.unwrap(deviceName): java.lang.String)
      .deviceArn(DeviceArn.unwrap(deviceArn): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DeviceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        deviceFleetName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.deviceFleetName)
      .optionallyWith(
        iotThingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.iotThingName)
      .optionallyWith(
        registrationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.registrationTime)
      .optionallyWith(
        latestHeartbeat.map(value => Timestamp.unwrap(value): Instant)
      )(_.latestHeartbeat)
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .optionallyWith(
        agentVersion.map(value => EdgeVersion.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeviceSummary.ReadOnly =
    zio.aws.sagemaker.model.DeviceSummary.wrap(buildAwsValue())
}
object DeviceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeviceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeviceSummary =
      zio.aws.sagemaker.model.DeviceSummary(
        deviceName,
        deviceArn,
        description.map(value => value),
        deviceFleetName.map(value => value),
        iotThingName.map(value => value),
        registrationTime.map(value => value),
        latestHeartbeat.map(value => value),
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        agentVersion.map(value => value)
      )
    def deviceName: EntityName
    def deviceArn: DeviceArn
    def description: Optional[DeviceDescription]
    def deviceFleetName: Optional[EntityName]
    def iotThingName: Optional[ThingName]
    def registrationTime: Optional[Timestamp]
    def latestHeartbeat: Optional[Timestamp]
    def models
        : Optional[List[zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly]]
    def agentVersion: Optional[EdgeVersion]
    def getDeviceName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(deviceName)
    def getDeviceArn: ZIO[Any, Nothing, DeviceArn] = ZIO.succeed(deviceArn)
    def getDescription: ZIO[Any, AwsError, DeviceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceFleetName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("deviceFleetName", deviceFleetName)
    def getIotThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("iotThingName", iotThingName)
    def getRegistrationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registrationTime", registrationTime)
    def getLatestHeartbeat: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("latestHeartbeat", latestHeartbeat)
    def getModels: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("models", models)
    def getAgentVersion: ZIO[Any, AwsError, EdgeVersion] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceSummary
  ) extends zio.aws.sagemaker.model.DeviceSummary.ReadOnly {
    override val deviceName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceName())
    override val deviceArn: DeviceArn =
      zio.aws.sagemaker.model.primitives.DeviceArn(impl.deviceArn())
    override val description: Optional[DeviceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.DeviceDescription(value)
        )
    override val deviceFleetName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceFleetName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val iotThingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.iotThingName())
      .map(value => zio.aws.sagemaker.model.primitives.ThingName(value))
    override val registrationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.registrationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val latestHeartbeat: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestHeartbeat())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val models
        : Optional[List[zio.aws.sagemaker.model.EdgeModelSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.models())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.EdgeModelSummary.wrap(item)
          }.toList
        )
    override val agentVersion: Optional[EdgeVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.agentVersion())
      .map(value => zio.aws.sagemaker.model.primitives.EdgeVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeviceSummary
  ): zio.aws.sagemaker.model.DeviceSummary.ReadOnly = new Wrapper(impl)
}
