package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ProcessingJobName
import scala.jdk.CollectionConverters.*
final case class DescribeProcessingJobRequest(
    processingJobName: ProcessingJobName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest = {
    import DescribeProcessingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest
      .builder()
      .processingJobName(
        ProcessingJobName.unwrap(processingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeProcessingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeProcessingJobRequest.wrap(buildAwsValue())
}
object DescribeProcessingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeProcessingJobRequest =
      zio.aws.sagemaker.model.DescribeProcessingJobRequest(processingJobName)
    def processingJobName: ProcessingJobName
    def getProcessingJobName: ZIO[Any, Nothing, ProcessingJobName] =
      ZIO.succeed(processingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest
  ) extends zio.aws.sagemaker.model.DescribeProcessingJobRequest.ReadOnly {
    override val processingJobName: ProcessingJobName =
      zio.aws.sagemaker.model.primitives
        .ProcessingJobName(impl.processingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest
  ): zio.aws.sagemaker.model.DescribeProcessingJobRequest.ReadOnly =
    new Wrapper(impl)
}
