package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.WorkforceName
import scala.jdk.CollectionConverters.*
final case class CreateWorkforceRequest(
    cognitoConfig: Optional[zio.aws.sagemaker.model.CognitoConfig] =
      Optional.Absent,
    oidcConfig: Optional[zio.aws.sagemaker.model.OidcConfig] = Optional.Absent,
    sourceIpConfig: Optional[zio.aws.sagemaker.model.SourceIpConfig] =
      Optional.Absent,
    workforceName: WorkforceName,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    workforceVpcConfig: Optional[
      zio.aws.sagemaker.model.WorkforceVpcConfigRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest = {
    import CreateWorkforceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest
      .builder()
      .optionallyWith(cognitoConfig.map(value => value.buildAwsValue()))(
        _.cognitoConfig
      )
      .optionallyWith(oidcConfig.map(value => value.buildAwsValue()))(
        _.oidcConfig
      )
      .optionallyWith(sourceIpConfig.map(value => value.buildAwsValue()))(
        _.sourceIpConfig
      )
      .workforceName(WorkforceName.unwrap(workforceName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(workforceVpcConfig.map(value => value.buildAwsValue()))(
        _.workforceVpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateWorkforceRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateWorkforceRequest.wrap(buildAwsValue())
}
object CreateWorkforceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateWorkforceRequest =
      zio.aws.sagemaker.model.CreateWorkforceRequest(
        cognitoConfig.map(value => value.asEditable),
        oidcConfig.map(value => value.asEditable),
        sourceIpConfig.map(value => value.asEditable),
        workforceName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workforceVpcConfig.map(value => value.asEditable)
      )
    def cognitoConfig: Optional[zio.aws.sagemaker.model.CognitoConfig.ReadOnly]
    def oidcConfig: Optional[zio.aws.sagemaker.model.OidcConfig.ReadOnly]
    def sourceIpConfig
        : Optional[zio.aws.sagemaker.model.SourceIpConfig.ReadOnly]
    def workforceName: WorkforceName
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def workforceVpcConfig
        : Optional[zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly]
    def getCognitoConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CognitoConfig.ReadOnly] =
      AwsError.unwrapOptionField("cognitoConfig", cognitoConfig)
    def getOidcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.OidcConfig.ReadOnly] =
      AwsError.unwrapOptionField("oidcConfig", oidcConfig)
    def getSourceIpConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SourceIpConfig.ReadOnly] =
      AwsError.unwrapOptionField("sourceIpConfig", sourceIpConfig)
    def getWorkforceName: ZIO[Any, Nothing, WorkforceName] =
      ZIO.succeed(workforceName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkforceVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly
    ] = AwsError.unwrapOptionField("workforceVpcConfig", workforceVpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest
  ) extends zio.aws.sagemaker.model.CreateWorkforceRequest.ReadOnly {
    override val cognitoConfig
        : Optional[zio.aws.sagemaker.model.CognitoConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoConfig())
        .map(value => zio.aws.sagemaker.model.CognitoConfig.wrap(value))
    override val oidcConfig
        : Optional[zio.aws.sagemaker.model.OidcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oidcConfig())
        .map(value => zio.aws.sagemaker.model.OidcConfig.wrap(value))
    override val sourceIpConfig
        : Optional[zio.aws.sagemaker.model.SourceIpConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceIpConfig())
        .map(value => zio.aws.sagemaker.model.SourceIpConfig.wrap(value))
    override val workforceName: WorkforceName =
      zio.aws.sagemaker.model.primitives.WorkforceName(impl.workforceName())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val workforceVpcConfig
        : Optional[zio.aws.sagemaker.model.WorkforceVpcConfigRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workforceVpcConfig())
        .map(value =>
          zio.aws.sagemaker.model.WorkforceVpcConfigRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest
  ): zio.aws.sagemaker.model.CreateWorkforceRequest.ReadOnly = new Wrapper(impl)
}
