package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelCardExportJobArn
import scala.jdk.CollectionConverters.*
final case class CreateModelCardExportJobResponse(
    modelCardExportJobArn: ModelCardExportJobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobResponse = {
    import CreateModelCardExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobResponse
      .builder()
      .modelCardExportJobArn(
        ModelCardExportJobArn.unwrap(modelCardExportJobArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelCardExportJobResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateModelCardExportJobResponse
      .wrap(buildAwsValue())
}
object CreateModelCardExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateModelCardExportJobResponse =
      zio.aws.sagemaker.model
        .CreateModelCardExportJobResponse(modelCardExportJobArn)
    def modelCardExportJobArn: ModelCardExportJobArn
    def getModelCardExportJobArn: ZIO[Any, Nothing, ModelCardExportJobArn] =
      ZIO.succeed(modelCardExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobResponse
  ) extends zio.aws.sagemaker.model.CreateModelCardExportJobResponse.ReadOnly {
    override val modelCardExportJobArn: ModelCardExportJobArn =
      zio.aws.sagemaker.model.primitives
        .ModelCardExportJobArn(impl.modelCardExportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobResponse
  ): zio.aws.sagemaker.model.CreateModelCardExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
