package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionArn
import scala.jdk.CollectionConverters.*
final case class CreateModelBiasJobDefinitionResponse(
    jobDefinitionArn: MonitoringJobDefinitionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse = {
    import CreateModelBiasJobDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse
      .builder()
      .jobDefinitionArn(
        MonitoringJobDefinitionArn.unwrap(jobDefinitionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse
      .wrap(buildAwsValue())
}
object CreateModelBiasJobDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse =
      zio.aws.sagemaker.model
        .CreateModelBiasJobDefinitionResponse(jobDefinitionArn)
    def jobDefinitionArn: MonitoringJobDefinitionArn
    def getJobDefinitionArn: ZIO[Any, Nothing, MonitoringJobDefinitionArn] =
      ZIO.succeed(jobDefinitionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse
  ) extends zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.ReadOnly {
    override val jobDefinitionArn: MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionArn(impl.jobDefinitionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse
  ): zio.aws.sagemaker.model.CreateModelBiasJobDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
