package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait CompleteOnConvergence {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence
}
object CompleteOnConvergence {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence
  ): zio.aws.sagemaker.model.CompleteOnConvergence = value match {
    case software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence.DISABLED =>
      val r = Disabled
      r
    case software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence.ENABLED =>
      val r = Enabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CompleteOnConvergence {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence =
      software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence.UNKNOWN_TO_SDK_VERSION
  }
  case object Disabled extends zio.aws.sagemaker.model.CompleteOnConvergence {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence =
      software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence.DISABLED
  }
  case object Enabled extends zio.aws.sagemaker.model.CompleteOnConvergence {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence =
      software.amazon.awssdk.services.sagemaker.model.CompleteOnConvergence.ENABLED
  }
}
