package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Autotune(mode: zio.aws.sagemaker.model.AutotuneMode) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Autotune = {
    import Autotune.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Autotune
      .builder()
      .mode(mode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Autotune.ReadOnly =
    zio.aws.sagemaker.model.Autotune.wrap(buildAwsValue())
}
object Autotune {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Autotune
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Autotune =
      zio.aws.sagemaker.model.Autotune(mode)
    def mode: zio.aws.sagemaker.model.AutotuneMode
    def getMode: ZIO[Any, Nothing, zio.aws.sagemaker.model.AutotuneMode] =
      ZIO.succeed(mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Autotune
  ) extends zio.aws.sagemaker.model.Autotune.ReadOnly {
    override val mode: zio.aws.sagemaker.model.AutotuneMode =
      zio.aws.sagemaker.model.AutotuneMode.wrap(impl.mode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Autotune
  ): zio.aws.sagemaker.model.Autotune.ReadOnly = new Wrapper(impl)
}
