package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{ParameterValue, ParameterKey}
import scala.jdk.CollectionConverters.*
final case class AutoParameter(name: ParameterKey, valueHint: ParameterValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoParameter = {
    import AutoParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoParameter
      .builder()
      .name(ParameterKey.unwrap(name): java.lang.String)
      .valueHint(ParameterValue.unwrap(valueHint): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoParameter.ReadOnly =
    zio.aws.sagemaker.model.AutoParameter.wrap(buildAwsValue())
}
object AutoParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoParameter =
      zio.aws.sagemaker.model.AutoParameter(name, valueHint)
    def name: ParameterKey
    def valueHint: ParameterValue
    def getName: ZIO[Any, Nothing, ParameterKey] = ZIO.succeed(name)
    def getValueHint: ZIO[Any, Nothing, ParameterValue] = ZIO.succeed(valueHint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoParameter
  ) extends zio.aws.sagemaker.model.AutoParameter.ReadOnly {
    override val name: ParameterKey =
      zio.aws.sagemaker.model.primitives.ParameterKey(impl.name())
    override val valueHint: ParameterValue =
      zio.aws.sagemaker.model.primitives.ParameterValue(impl.valueHint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoParameter
  ): zio.aws.sagemaker.model.AutoParameter.ReadOnly = new Wrapper(impl)
}
