package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AutoMLS3DataType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType
}
object AutoMLS3DataType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType
  ): zio.aws.sagemaker.model.AutoMLS3DataType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType.MANIFEST_FILE =>
      val r = ManifestFile
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType.S3_PREFIX =>
      val r = S3Prefix
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType.AUGMENTED_MANIFEST_FILE =>
      val r = AugmentedManifestFile
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLS3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType.UNKNOWN_TO_SDK_VERSION
  }
  case object ManifestFile extends zio.aws.sagemaker.model.AutoMLS3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType.MANIFEST_FILE
  }
  case object S3Prefix extends zio.aws.sagemaker.model.AutoMLS3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType.S3_PREFIX
  }
  case object AugmentedManifestFile
      extends zio.aws.sagemaker.model.AutoMLS3DataType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLS3DataType.AUGMENTED_MANIFEST_FILE
  }
}
