package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait AutoMLMetricExtendedEnum {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum
}
object AutoMLMetricExtendedEnum {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum
  ): zio.aws.sagemaker.model.AutoMLMetricExtendedEnum = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.ACCURACY =>
      val r = Accuracy
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.MSE =>
      val r = MSE
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.F1 =>
      val r = F1
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.F1_MACRO =>
      val r = F1macro
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.AUC =>
      val r = AUC
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.RMSE =>
      val r = RMSE
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.MAE =>
      val r = MAE
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.R2 =>
      val r = R2
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.BALANCED_ACCURACY =>
      val r = BalancedAccuracy
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.PRECISION =>
      val r = Precision
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.PRECISION_MACRO =>
      val r = PrecisionMacro
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.RECALL =>
      val r = Recall
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.RECALL_MACRO =>
      val r = RecallMacro
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.LOG_LOSS =>
      val r = LogLoss
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.INFERENCE_LATENCY =>
      val r = InferenceLatency
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object Accuracy
      extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.ACCURACY
  }
  case object MSE extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.MSE
  }
  case object F1 extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.F1
  }
  case object F1macro extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.F1_MACRO
  }
  case object AUC extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.AUC
  }
  case object RMSE extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.RMSE
  }
  case object MAE extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.MAE
  }
  case object R2 extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.R2
  }
  case object BalancedAccuracy
      extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.BALANCED_ACCURACY
  }
  case object Precision
      extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.PRECISION
  }
  case object PrecisionMacro
      extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.PRECISION_MACRO
  }
  case object Recall extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.RECALL
  }
  case object RecallMacro
      extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.RECALL_MACRO
  }
  case object LogLoss extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.LOG_LOSS
  }
  case object InferenceLatency
      extends zio.aws.sagemaker.model.AutoMLMetricExtendedEnum {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum =
      software.amazon.awssdk.services.sagemaker.model.AutoMLMetricExtendedEnum.INFERENCE_LATENCY
  }
}
