package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AlarmName
import scala.jdk.CollectionConverters.*
final case class Alarm(alarmName: Optional[AlarmName] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Alarm = {
    import Alarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Alarm
      .builder()
      .optionallyWith(
        alarmName.map(value => AlarmName.unwrap(value): java.lang.String)
      )(_.alarmName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Alarm.ReadOnly =
    zio.aws.sagemaker.model.Alarm.wrap(buildAwsValue())
}
object Alarm {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Alarm] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Alarm =
      zio.aws.sagemaker.model.Alarm(alarmName.map(value => value))
    def alarmName: Optional[AlarmName]
    def getAlarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Alarm
  ) extends zio.aws.sagemaker.model.Alarm.ReadOnly {
    override val alarmName: Optional[AlarmName] = zio.aws.core.internal
      .optionalFromNullable(impl.alarmName())
      .map(value => zio.aws.sagemaker.model.primitives.AlarmName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Alarm
  ): zio.aws.sagemaker.model.Alarm.ReadOnly = new Wrapper(impl)
}
