package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ArtifactArn
import scala.jdk.CollectionConverters.*
final case class UpdateArtifactResponse(
    artifactArn: Optional[ArtifactArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse = {
    import UpdateArtifactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse
      .builder()
      .optionallyWith(
        artifactArn.map(value => ArtifactArn.unwrap(value): java.lang.String)
      )(_.artifactArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateArtifactResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateArtifactResponse.wrap(buildAwsValue())
}
object UpdateArtifactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateArtifactResponse =
      zio.aws.sagemaker.model
        .UpdateArtifactResponse(artifactArn.map(value => value))
    def artifactArn: Optional[ArtifactArn]
    def getArtifactArn: ZIO[Any, AwsError, ArtifactArn] =
      AwsError.unwrapOptionField("artifactArn", artifactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse
  ) extends zio.aws.sagemaker.model.UpdateArtifactResponse.ReadOnly {
    override val artifactArn: Optional[ArtifactArn] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactArn())
      .map(value => zio.aws.sagemaker.model.primitives.ArtifactArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse
  ): zio.aws.sagemaker.model.UpdateArtifactResponse.ReadOnly = new Wrapper(impl)
}
